/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE

/////////////////////////////////////////////////////////////////////////////////

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

/////////////////////////////////////////////////////////////////////////////////

#define maxSteps 96.0
#define treshold 0.001
#define maxdist 20.0
#define pi acos(-1.)
#define oid1 1.0
#define oid2 2.0
#define shadowsteps 30.0
#define screenRatio vec2(iResolution.x/iResolution.y, 1.0)

#define numleafs 8.0


vec2 rot(vec2 k, float t) {
	return vec2(cos(t)*k.x-sin(t)*k.y,sin(t)*k.x+cos(t)*k.y);
	}

float perlin(vec3 p) {
	vec3 i = floor(p);
	vec4 a = dot(i, vec3(1., 57., 21.)) + vec4(0., 57., 21., 78.);
	vec3 f = cos((p-i)*pi)*(-.5)+.5;
	a = mix(sin(cos(a)*a),sin(cos(1.+a)*(1.+a)), f.x);
	a.xy = mix(a.xz, a.yw, f.y);
	return mix(a.x, a.y, f.z);
	}

vec3 leaftex(vec3 p) {
	float q=perlin(p);
	vec3 col=vec3(0.9,0.1,0.1)+q*0.8;
	return col;
	}

vec3 pettex(vec3 p) {
	float q=perlin(p);
	vec3 col=vec3(0.5,0.4,0.0)+q*0.5;
	return col;
	}

vec2 opU( vec2 d1, vec2 d2 ){
	return (d1.x<d2.x) ? d1 : d2;
	}

float leaf( vec3 p, vec3 t, vec3 r ) {
	vec3 q=p;
	q.xy=rot(q.xy,r.x);		//rotate
	q.xz=rot(q.xz,r.y);		//rotate
	q.zy=rot(q.zy,r.z);		//rotate
	q= (q-t);			//translate
	q*=mat3( (cos(q.x)+1.60), 0.0, 0.0, sin(q.x)*1.3, 1.0, -cos(q.z)*0.8, 0.0, 0.0, 1.0);	//model
	
	float d=(sin(q.x*6.0)*sin(q.y*10.0)*sin(q.z*2.0))*0.04;	//distort
	
	return max( length(q.xz)-1.0,  abs(q.y)-0.001 )  *0.5 -d;
	}

vec2 map(vec3 p ) {

	float d=(sin(p.x*80.0)*sin(p.y*80.0)*sin(p.z*80.0))*0.008;
	vec2 ret= vec2( length(p) -0.5 -d , oid1);
	
	float ro=0.0;
	for (float i=0.0; i<numleafs; i++) {
		ret=opU(ret, vec2( leaf(p, vec3(0.0,0.3,1.4), vec3(radians(180.0),radians(ro),radians(-10.0)) ), oid2));
		ret=opU(ret, vec2( leaf(p, vec3(0.0,0.393,1.4), vec3(radians(180.0),radians(ro+360.0/numleafs/2.0),radians(11.0)) ), oid2 ));
		ro+=360.0/numleafs;
	}
	
	return ret;
	}

vec3 cNor(vec3 p ) {
	vec3 e=vec3(0.001,0.0,0.0);
	return normalize(vec3( map(p+e.xyy).x - map(p-e.xyy).x, map(p+e.yxy).x - map(p-e.yxy).x, map(p+e.yyx).x - map(p-e.yyx).x ));
	}

float calcAO(vec3 pos, vec3 nor ){
	float totao = 0.0;
    float sca = 1.0;
    for( float aoi=0.0; aoi<5.0; aoi+=1.0 ) {
        float hr = 0.01 + 0.05*aoi;
        vec3 aopos =  nor * hr + pos;
        float dd = map( aopos ).x;
        totao += -(dd-hr)*sca;
        sca *= 0.75;
    }
    return clamp( 1.0 - 4.0*totao, 0.0, 1.0 );
}


float cShd(vec3 ro, vec3 rd, float k ) {
	float res = 1.0;
	for(float i=1.0; i<shadowsteps; i+=1.0){
		float f=shadowsteps/i;
        float h = map(ro + rd*f).x;
        if( h<0.001 ) { res=0.0; break; }
        res = min( res, k*h/f );
    }
    return res;
}

void main(void)	{
	vec2 ps=(gl_FragCoord.xy/iResolution.xy);
	vec3 rd=normalize( vec3( (-1.0+2.0*ps)*screenRatio, 1.0));
	vec3 ro=vec3(0.0, 0.0, -3.0);
	vec3 lig=vec3(1.0,1.0,-1.0);
	
	float r=radians(70.0)+sin(iGlobalTime)*.8;
	float k=radians(40.0);
	
	vec4 m=iMouse*0.01;
	lig.xz=rot(lig.xz, m.x+r);
	lig.xy=rot(lig.xy, m.y+k);
	ro.xz=rot(ro.xz, m.x+r);
	ro.xy=rot(ro.xy, m.y+k);
	rd.xz=rot(rd.xz, m.x+r);
	rd.xy=rot(rd.xy, m.y+k);	
	
	float f=0.0;
	vec2 t=vec2(treshold,f);
	for(float i=0.0; i<1.0; i+=1.0/maxSteps){
        t= map(ro + rd*t.x);
		f+=t.x;
		t.x=f;
		if( abs(t.x)<treshold || t.x>maxdist ) { t.y=0.0; break; }
		}

	vec3 col = vec3(0.0);
	if (t.y>0.5) {
		
		lig=normalize(lig);
		vec3 pos = ro + rd*t.x;
		vec3 nor = cNor(pos);
		float ao = calcAO( pos, nor );
		
		float amb = clamp( 0.5+0.5*nor.y, 0.0, 1.0 );					
		float dif = clamp( dot( nor, lig ), 0.0, 1.0 );					
		float bac = clamp( dot( nor, vec3(-lig.x,lig.y,-lig.z)), 0.0, 1.0 );		

		float sh = cShd( pos, lig, 1.0 );	

		col = 0.20*amb*vec3(0.10,0.10,0.10)*ao;						
		col += 0.20*bac*vec3(0.15,0.15,0.15)*ao;					
		col += 1.90*dif*vec3(0.80,0.80,0.80);						

		float spe = sh*pow(clamp( dot( lig, reflect(rd,nor) ), 0.0, 1.0 ) ,16.0 );	
		float rim = ao*pow(clamp( 1.0+dot(nor,rd),0.0,1.0), 2.0 );			

		vec3 oc;
		if (t.y == oid1) oc=pettex(pos*nor);
		if (t.y == oid2) oc=leaftex(pos*nor);

		col =oc*col + vec3(1.0)*col*spe + 0.2*rim*(0.5+0.5*col);		

	} 
		
	gl_FragColor=vec4( col, 1.0);
	}
	
	